<?php
return [
  'customer-table' => [
      'name' => 'Customer',
      'slug' => 'customer',
      'description' => 'This table contains customer details, including personal information, contact details, and account-related data.',
      'export' => true,
      'import' => true,
      'export_route' => 'backend.user.export',
      'import_route' => 'backend.user.import.csv',
      'instruction_file' => 'admin/images/import-files/user_import_format.txt',
      'example_file' => 'admin/images/export-files/users.csv',
  ],
  'user-table' => [
    'name' => 'User',
    'slug' => 'user',
    'description' => 'This table contains user details, including personal information, contact details, and account-related data.',
    'export' => true,
    'import' => true,
    'export_route' => 'backend.user.export',
    'import_route' => 'backend.user.import.csv',
    'instruction_file' => 'admin/images/import-files/user_import_format.txt',
    'example_file' => 'admin/images/export-files/users.csv',
],
  'provider-table' => [
    'name' => 'Provider',
    'slug' => 'provider',
    'description' => 'This table stores provider details, including business information, contact details, and service-related data.',
    'export' => true,
    'import' => true,
    'export_route' => 'backend.provider.export',
    'import_route' => 'backend.provider.import.csv',
    'instruction_file' => 'admin/images/import-files/provider_import.txt',
    'example_file' => 'admin/images/export-files/providers.csv',
  ],
  'provider-documents-table' => [
    'name' => 'Provider Documents',
    'slug' => 'provider-documents',
    'description' => 'This table manages provider-related documents, such as licenses, certifications, and identity verifications.',
    'export' => true,
    'import' => true,
    'export_route' => 'backend.provider-document.export',
    'import_route' => 'backend.provider-document.import.csv',
    'instruction_file' => 'admin/images/import-files/provider_document_import.txt',
    'example_file' => 'admin/images/export-files/providerDocument.csv',
  ],
  'commission-histories' => [
    'name' => 'Commission Histories',
    'slug' => 'commission-histories',
    'description' => 'This table records the commission history for providers, tracking earnings, deductions, and transaction details.',
    'export' => true,
    'export_route' => 'backend.commission.export',
    'example_file' => 'admin/images/export-files/commission_histories.csv',
  ],
  'serviceman' => [
    'name' => 'Serviceman',
    'slug' => 'serviceman',
    'description' => 'This table records the commission history for providers, tracking earnings, deductions, and transaction details.',
    'export' => true,
    'import' => true,
    'export_route' => 'backend.serviceman.export',
    'import_route' => 'backend.serviceman.import.csv',
    'instruction_file' => 'admin/images/import-files/serviceman_import_instructions.txt',
    'example_file' => 'admin/images/export-files/servicemen.csv',
  ],
  'zones' => [
    'name' => 'Zones',
    'slug' => 'zones',
    'description' => 'This table records the commission history for providers, tracking earnings, deductions, and transaction details.',
    'export' => true,
    'import' => true,
    'export_route' => 'backend.zone.export',
    'import_route' => 'backend.zone.import.csv',
    'instruction_file' => 'admin/images/import-files/category_import.txt',
    'example_file' => 'admin/images/export-files/zones.csv',
  ],
  'services' => [
    'name' => 'Service',
    'slug' => 'services',
    'description' => 'This table records the commission history for providers, tracking earnings, deductions, and transaction details.',
    'export' => true,
    'import' => true,
    'export_route' => 'backend.service.export',
    'import_route' => 'backend.service.import',
    'instruction_file' => 'admin/images/import-files/service_import_instructions.txt',
    'example_file' => 'admin/images/export-files/services.csv',
  ],
  'additional_services' => [
    'name' => 'Additional Service',
    'slug' => 'additional-services',
    'description' => 'This table records the commission history for providers, tracking earnings, deductions, and transaction details.',
    'export' => true,
    'import' => true,
    'export_route' => 'backend.additional-service.export',
    'import_route' => 'backend.additional-service.import.csv',
    'instruction_file' => 'admin/images/import-files/add_on_service_import.txt',
    'example_file' => 'admin/images/export-files/add-on-services.csv',
  ],
  'service_packages' => [
    'name' => 'Service Packages',
    'slug' => 'service-packages',
    'description' => 'This table records the commission history for providers, tracking earnings, deductions, and transaction details.',
    'export' => true,
    'import' => true,
    'export_route' => 'backend.service-package.export',
    'import_route' => 'backend.service-package.import.csv',
    'instruction_file' => 'admin/images/import-files/service_package_import.txt',
    'example_file' => 'admin/images/export-files/service-packages.csv',
  ],
  'bookings' => [
    'name' => 'Bookings',
    'slug' => 'bookings',
    'description' => 'This table records the commission history for providers, tracking earnings, deductions, and transaction details.',
    'export' => true,
    'export_route' => 'backend.booking.export',

    'example_file' => 'admin/images/export-files/bookings.csv',
  ],
  'transactions' => [
    'name' => 'Transactions',
    'slug' => 'transactions',
    'description' => 'This table records the commission history for providers, tracking earnings, deductions, and transaction details.',
    'export' => true,
    'export_route' => 'backend.transaction.export',
    'example_file' => 'admin/images/export-files/transactions.csv',
  ],
  'categories' => [
    'name' => 'Categories',
    'slug' => 'categories',
    'description' => 'This table records the commission history for providers, tracking earnings, deductions, and transaction details.',
    'export' => true,
    'import' => true,
    'export_route' => 'backend.category.export',
    'import_route' => 'backend.category.import',
    'instruction_file' => 'admin/images/import-files/category_import.txt',
    'example_file' => 'admin/images/export-files/categories.csv',
  ],
];
